<?php
    get_header();
?>
    <!-- Full Width Image -->
    <section class="bg-topo margin-menu" id="sobre" style="background-image:url('<?php echo get_field('banner_sobre', 'options'); ?>')">
        <div class="container"> 
            <div class="row">
                <div class="col-sm-2 col-xs-1"></div>
                <div class="col-sm-8 col-xs-10 text-center">
                    <h3 class="white bold uppercase text-center sansdis"><?php echo get_field('titulo_sobre', 'options'); ?></h3>
                    <h2 class="white italic text-center margint80"><?php echo get_field('texto_sobre', 'options'); ?></h2>
                </div>
            </div>
        </div>
    </section>

    <!-- Cafés -->
    <section id="cafes" class="bg-white">
        <div class="container"> 
            <div class="row">
                <div class="col-sm-12 text-center">
                    <h3 class="black bold uppercase sansdis">CAFÉS SELECIONADOS</h3>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12"> 
                    <?php $i=0; while ( have_rows('cafes_selecionados', 'options') ) : the_row(); ?>
                        <?php if($i%4 == 0) : ?>
                            <div class="row margint15">
                        <?php endif; ?>
                            <div class="col-xs-3">
                                <h5 class="black uppercase heavitas"><?php echo get_sub_field('nome_cafe', 'options'); ?></h5>
                                <h6 class="gray uppercase heavitas"><?php echo get_sub_field('infos_1', 'options'); ?><br><?php echo get_sub_field('infos_2', 'options'); ?></h6>
                                <p class="min margint15 bold uppercase roboto"><a href="#" class="black" data-toggle="modal" data-target="#cafes-selecionados<?php echo $i; ?>">Veja Mais</a></p>
                            </div>
                            <div class="modal fade" id="cafes-selecionados<?php echo $i; ?>" tabindex="-1" role="dialog" aria-labelledby="cafes-selecionados<?php echo $i; ?>" aria-hidden="true">
                                <div class="vertical-alignment-helper">
                                    <div class="modal-dialog vertical-align-center">
                                        <div class="modal-content">
                                            <div class="close-modal" data-dismiss="modal">
                                                <div class="lr">
                                                    <div class="rl">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="clearfix">
                                                            <h3 class="black nomargin"><?php echo get_sub_field('nome_cafe', 'options'); ?></h3>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <h4 class="gray uppercase"><?php echo get_sub_field('infos_1', 'options'); ?><br><?php echo get_sub_field('infos_2', 'options'); ?></h4>
                                                        <p class="black"><?php echo get_sub_field('descricao'); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>       
                        <?php if($i%4 == 3) : ?>
                            </div>
                        <?php endif; ?>
                        <?php $i++; ?>
                    <?php endwhile; ?>
                    <?php if($i%4 != 0) : ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Onde Comprar -->
    <section id="ondecomprar" <?php if(!get_field('embalagem_cafe', 'options')) : echo 'class="nomargin"'; endif; ?>>
        <div class="container"> 
            <div class="row">
                <div class="col-sm-12 text-center">
                    <h3 class="black bold uppercase sansdis">ONDE ENCONTRAR</h3>
                </div>
            </div>
            <div class="row">
                <!-- tabs left -->
                <div class="tabs">
                    <div class="col-sm-3">
                        <div class="clearfix tab-left">
                            <ul class="nav nav-tabs">
                                <?php $i = 0; ?>
                                <?php $terms = get_terms( 'cidade', array('hide_empty' => false, 'orderby' => 'name') ); ?>
                                <?php foreach ($terms as $term) : ?>
                                    <?php if($i == 0) : ?>
                                        <li class="active"><a href="#<?php echo $term->slug; ?>" data-toggle="tab"><?php echo $term->name; ?></a></li>
                                    <?php else : ?>
                                        <li><a href="#<?php echo $term->slug; ?>" data-toggle="tab"><?php echo $term->name; ?></a></li>
                                    <?php endif; ?>
                                    <?php $i++; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="tab-content">
                            <?php $i = 0; ?>
                            <?php $cont = 1; ?>
                            <?php foreach ($terms as $term) : ?>
                                <?php if($i == 0) : ?>
                                    <div class="tab-pane active" id="<?php echo $term->slug; ?>">
                                        <?php query_posts(array('post_type' => 'unidade', 'showposts' => 8, 'cidade'=>$term->slug)); ?>
                                        <?php if (have_posts()) : ?>
                                            <div class="col-sm-12">
                                                <?php while(have_posts()) : the_post(); ?> 
                                                    <?php if(($cont-1)%4 == 0) : ?>
                                                        <div class="row">
                                                    <?php endif; ?>
                                                    <div class="col-sm-3">
                                                        <h5 class="black bold" style="background-image: url('<?php echo get_template_directory_uri(); ?>/img/icons/icon-<?php echo $cont; ?>.png');"><?php echo get_the_title(); ?></h5>
                                                        <p class="min gray roboto"><?php echo get_field('endereco'); echo $cont-1; ?></p>
                                                        <?php if(get_field('email')) : ?><p class="min bold margint15"><a href="mailto:<?php echo get_field('email'); ?>" class="black"><?php echo get_field('email'); ?></a></p><?php endif; ?>
                                                        <p class="min gray roboto"><?php echo get_field('telefones'); ?></p>
                                                        <?php $location = get_field('mapa'); ?>
                                                        <div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>" data-number="<?php echo $cont; ?>"></div>
                                                    </div>
                                                    <?php if(($cont-1)%4 == 3) : ?>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php $cont++; ?>
                                                <?php endwhile; ?>
                                                <?php if(($cont-1)%4 != 0) : ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php wp_reset_query(); ?>
                                    </div>
                                <?php else : ?>
                                    <div class="tab-pane" id="<?php echo $term->slug; ?>">
                                        <?php query_posts(array('post_type' => 'unidade', 'showposts' => 8, 'cidade'=>$term->slug)); ?>
                                        <?php if (have_posts()) : ?>
                                            <?php while(have_posts()) : the_post(); ?> 
                                                <div class="col-sm-3">
                                                    <h5 class="black bold" style="background-image: url('<?php echo get_template_directory_uri(); ?>/img/icons/icon-<?php echo $cont; ?>.png');"><?php echo get_the_title(); ?></h5>
                                                    <p class="min gray roboto"><?php echo get_field('endereco'); ?></p>
                                                    <p class="min bold margint15"><a href="mailto:<?php echo get_field('email'); ?>" class="black"><?php echo get_field('email'); ?></a></p>
                                                    <p class="min gray roboto"><?php echo get_field('telefones'); ?></p>
                                                    <?php $location = get_field('mapa'); ?>
                                                    <div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>" data-number="<?php echo $cont; ?>"></div>
                                                </div>
                                                <?php $cont++; ?>
                                            <?php endwhile; ?>
                                        <?php endif; ?>
                                        <?php wp_reset_query(); ?>
                                    </div>
                                <?php endif; ?>
                                <?php $i++; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="acf-map">
                    <?php $cont = 1; ?>
                    <?php foreach ($terms as $term) : ?>
                        <?php query_posts(array('post_type' => 'unidade', 'showposts' => 8, 'cidade'=>$term->slug)); ?>
                        <?php if (have_posts()) : ?>
                            <?php while(have_posts()) : the_post(); ?> 
                                <?php $location = get_field('mapa'); ?>
                                <div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>" data-number="<?php echo $cont; ?>"></div>
                                <?php $cont++; ?>
                            <?php endwhile; ?>
                            <?php break; ?>
                        <?php endif; ?>
                        <?php wp_reset_query(); ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>
<?php
    get_footer();
?>