<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Aha Cafés</title>

    <!--favicon PNG-->
    <link rel="icon"  type="image/png" href="<?php bloginfo('template_directory'); ?>/img/favicon.png">

    <!-- Bootstrap Core CSS -->
    <link href="<?php bloginfo('template_directory'); ?>/css/bootstrap.min.css" rel="stylesheet">

    <link href="<?php bloginfo('template_directory'); ?>/owl-carousel/owl.carousel.css" rel="stylesheet">
    <link href="<?php bloginfo('template_directory'); ?>/owl-carousel/owl.theme.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="<?php bloginfo('template_directory'); ?>/css/agency.css" rel="stylesheet">

    <!-- Custom Fonts -->
    <link href="<?php bloginfo('template_directory'); ?>/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">

    <link rel="icon" type="image/png" href="<?php bloginfo('template_directory'); ?>/img/favicon.png" />
    
    <?php wp_head();?> 
</head>

<body <?php body_class(); ?> id="top">

    <!-- Navigation -->
    <nav id="mainNav" class="navbar navbar-custom navbar-fixed-top bg-white">
        <div class="bg-gray" id="topo">
            <div class="container text-center"> 
                <div class="row">
                    <div class="col-xs-4">
                        <h5 class="white roboto">
                            <?php if(get_field('info_topo_1_link', 'options')) : ?>
                                <a href="<?php echo get_field('info_topo_1_link', 'options'); ?>">
                                    <?php echo get_field('info_topo_1', 'options'); ?>
                                </a>
                            <?php else : ?>
                                <?php echo get_field('info_topo_1', 'options'); ?>
                            <?php endif; ?>
                        </h5>
                    </div>

                    <div class="col-xs-4">
                        <h5 class="white roboto">
                            <?php if(get_field('info_topo_2_link', 'options')) : ?>
                                <a href="<?php echo get_field('info_topo_2_link', 'options'); ?>">
                                    <?php echo get_field('info_topo_2', 'options'); ?>
                                </a>
                            <?php else : ?>
                                <?php echo get_field('info_topo_2', 'options'); ?>
                            <?php endif; ?>
                        </h5>
                    </div>

                    <div class="col-xs-4">
                        <h5 class="white roboto">
                            <?php if(get_field('info_topo_3_link', 'options')) : ?>
                                <a href="<?php echo get_field('info_topo_3_link', 'options'); ?>">
                                    <?php echo get_field('info_topo_3', 'options'); ?>
                                </a>
                            <?php else : ?>
                                <?php echo get_field('info_topo_3', 'options'); ?>
                            <?php endif; ?>
                        </h5>
                    </div>  
                </div>
            </div>
        </div>
        <div class="container">
            <!-- Brand and toggle get grouped for better mobile display -->
            <div class="navbar-header page-scroll">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                    <span class="sr-only">Toggle navigation</span> <i class="fa fa-bars"></i>
                </button>
                <a class="navbar-brand page-scroll" href="#top"><img src="<?php bloginfo('template_directory'); ?>/img/logo-topo.png" class="img-responsive"></a>
            </div>

            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                <h1 class="black bold text-right"><?php echo get_field('frase_destaque_topo', 'options'); ?></h1>
                <ul class="nav navbar-nav navbar-right">
                    <li>
                        <a class="page-scroll" href="#top">Topo</a>
                    </li>
                    <li>
                        <a class="page-scroll-sobre" href="#sobre">Sobre</a>
                    </li>
                    <li>
                        <a class="page-scroll-aux" href="#cafes">Cafés</a>
                    </li>
                    <li>
                        <a class="page-scroll-aux-max" href="#ondecomprar">Onde comprar</a>
                    </li>
                    <li>
                        <a class="page-scroll-aux" href="#contato">Contato</a>
                    </li>                    
                </ul>
            </div>
            <!-- /.navbar-collapse -->
        </div>
        <!-- /.container-fluid -->
    </nav>